"use strict";

const animation_headingPrimary = anime({
	targets: ".header__heading-primary",
	top: [60, 0],
	opacity: [0, 1],
	duration: 1200,
	easing: "easeInOutQuad"
});

const animation_headingSecondary = anime({
	targets: ".header__heading-secondary",
	top: [30, 0],
	opacity: [0, 1],
	duration: 1800,
	delay: 1200,
	easing: "easeInOutQuad"
});

const animation_headingTertiary = anime({
	targets: ".header__heading-tertiary",
	right: [-30, 0],
	opacity: [0, 1],
	duration: 1800,
	delay: 2400,
	easing: "easeInOutQuad"
});

const animation_btnHeading = anime({
	targets: ".header__btn",
	bottom: ["10rem", "18rem"],
	opacity: [0, 1],
	duration: 2000,
	delay: 2600,
	easing: "easeInOutQuad"
});

const animation_facebookNotificationLabel = anime({
	targets: ".facebook__label",
	scaleX: [0, 1],
	duration: 1000,
	easing: "cubicBezier(1,0,.29,1.01)",
	autoplay: false
});

const animation_facebookNotificationMessage = anime({
	targets: ".facebook__message",
	translateX: [440, -600],
	duration: 8000,
	loop: true,
	easing: "linear",
	autoplay: false
});

const animation_ratingPopupOpening = anime({
	targets: ".rating",
	keyframes: [
		{bottom: "-20rem", opacity: 0},
		{bottom: "8rem", opacity: 1}
	],
	duration: 4000,
	easing: "spring(1, 80, 10, 0)",
	autoplay: false
});

const animation_ratingPopupClosing = anime({
	targets: ".rating",
	bottom: ["8rem", "-20rem"],
	duration: 1500,
	easing: "easeInQuad",
	autoplay: false
});
