<?php get_header(); ?>

<header class="header">
	<div class="header__text-container">
		<h1 class="header__heading-primary">Liceum Aktorskie</h1>
		<h2 class="header__heading-secondary">Jesteśmy różni - rozwijamy się razem</h2>
		<h3 class="header__heading-tertiary">- już od <strong class="important">30</strong> lat.</h3>
	</div>
	<img class="header__logo" src="<?= get_theme_file_uri("assets/img/logo.png?as=webp") ?>" alt="" />
	<div class="header__btn">
		<a class="btn-cta" href="<?= esc_url(site_url("/konkurs-recytatorski")); ?>">Konkurs recytatorski</a>
	</div>
</header>
<section class="section" id="section-classes">
	<div class="text-center u-heading">
		<h1 class="heading-primary">Czego się u nas nauczysz?</h1>
		<span class="subheading">Wybierz przedmiot z list i zobacz film, w którym pokażemy, jak to będzie
			wyglądać.</span>
	</div>
	<div class="classes-background"></div>
	<div class="classes flex flex-column g-4">
		<div class="classes__nav">
			<div class="splide">
				<div class="splide__track classes__slider">
					<ul class="splide__list">
						<li class="splide__slide classes__slide">
							<div class="classes__badge" data-video="https://www.youtube.com/embed/0ybKuVLtr1A?controls=0" data-image="classes-bg-aktorstwo">
								<span class="classes__badge-icon material-icons" aria-hidden="true">theater_comedy</span><span class="classes__badge-text">Aktorstwo</span>
							</div>
						</li>
						<li class="splide__slide classes__slide">
							<div class="classes__badge" data-video="https://www.youtube.com/embed/STOe8Xd2awQ?controls=0" data-image="classes-bg-monologi">
								<span class="classes__badge-icon material-icons" aria-hidden="true">textsms</span><span class="classes__badge-text">Monologi</span>
							</div>
						</li>
						<li class="splide__slide classes__slide">
							<div class="classes__badge" data-video="https://www.youtube.com/embed/vE6mMRS2dP8?controls=0" data-image="classes-bg-piosenka">
								<span class="classes__badge-icon material-icons" aria-hidden="true">music_note</span><span class="classes__badge-text">Piosenka</span>
							</div>
						</li>
						<li class="splide__slide classes__slide">
							<div class="classes__badge" data-video="https://www.youtube.com/embed/EBZVDFZUtSA?controls=0" data-image="classes-bg-dykcja">
								<span class="classes__badge-icon material-icons" aria-hidden="true">record_voice_over</span><span class="classes__badge-text">Dykcja i wymowa</span>
							</div>
						</li>
						<li class="splide__slide classes__slide">
							<div class="classes__badge" data-video="https://www.youtube.com/embed/3-tk2VE6jTs?controls=0" data-image="classes-bg-taniec">
								<span class="classes__badge-icon material-icons" aria-hidden="true">speaker</span><span class="classes__badge-text">Taniec</span>
							</div>
						</li>
						<li class="splide__slide classes__slide">
							<div class="classes__badge" data-video="https://www.youtube.com/embed/edA-S2w0BCI?controls=0" data-image="classes-bg-rytmika">
								<span class="classes__badge-icon material-icons" aria-hidden="true">hearing</span><span class="classes__badge-text">Rytmika</span>
							</div>
						</li>
						<li class="splide__slide classes__slide">
							<div class="classes__badge" data-video="https://www.youtube.com/embed/021SoeLTVNQ?controls=0" data-image="classes-bg-emisja">
								<span class="classes__badge-icon material-icons" aria-hidden="true">graphic_eq</span><span class="classes__badge-text">Emisja głosu</span>
							</div>
						</li>
						<li class="splide__slide classes__slide">
							<div class="classes__badge" data-video="https://www.youtube.com/embed/20facspdzuE?controls=0" data-image="classes-bg-logopeda">
								<span class="classes__badge-icon material-icons" aria-hidden="true">face</span><span class="classes__badge-text">Kons. logopedyczne</span>
							</div>
						</li>
						<li class="splide__slide classes__slide">
							<div class="classes__badge" data-video="https://www.youtube.com/embed/uohyBLEDwKw?controls=0" data-image="classes-bg-kariera">
								<span class="classes__badge-icon material-icons" aria-hidden="true">history</span><span class="classes__badge-text">Kons. kariery</span>
							</div>
						</li>
					</ul>
				</div>
			</div>
		</div>
		<div class="classes__body">
			<p class="classes__placeholder">Klinkij, aby zobaczyć film</p>
			<div class="classes__body-content hidden">
				<h4 class="classes__heading heading-quartenary">Aktorstwo</h4>
				<div class="classes__video plyr__video-embed" id="player">
					<iframe src="https://www.youtube.com/embed/0ybKuVLtr1A?controls=0" title="Odtwarzacz YouTube" frameborder="0" loading="lazy" srcdoc="<style> * { padding: 0; margin: 0; overflow: hidden; } body, html { height: 100%; } img, svg { position: absolute; width: 100%; top: 0; bottom: 0; margin: auto; } svg { filter: drop-shadow(1px 1px 10px hsla(206.5, 70.7%, 8%)); transition: al .25s ease-in-out; } body:hover svg { filter: drop-shadow(1px 1px 10px hsla(206.5, 70.7%, 8%)); transform: scale(1.2); }</style> <a href='${videoSrc}&autoplay=1'><img src='https://img.youtube.com/vi/20facspdzuE/hqdefault.jpg' alt=''></a>" allow="clipboard-write; picture-in-picture"></iframe>
				</div>
			</div>
		</div>
	</div>
</section>
<section class="section  invisible opacity-0" id="section-why">
	<div class="text-center u-heading">
		<h1 class="heading-primary">Przekonaj się, dlaczego wybrać nasze liceum</h1>
	</div>
	<div class="why">
		<div class="row">
			<div class="col">
				<figure class="review review--1">
					<div class="review__top"></div>
					<div class="review__body">
						<h5 class="review__heading">Najlepsza Decyzja w Moim Życiu</h5>
						<p class="review__body-text">
							Wybrałem IX Prywatne Liceum bo, wydawała się to szkoła inna od
							wszystkich. Okazało się, że się nie myliłem. Szansa jaką to miejsce daje
							jest ogromna, ale to zależy tylko od tego, czy Ty ją wykorzystasz.
							Niesamowita wiedza i relacje jakie można zawiązać rekompensuje trud
							przygotowań do matury i egzaminów do szkół aktorskich. Jeśli miałbym
							znowu podjąć decyzję to nie wahałbym się ani trochę.
						</p>
						<span class="review__attribute">- Igor</span>
					</div>
				</figure>
			</div>
			<div class="col">
				<figure class="review review--2">
					<div class="review__top"></div>
					<div class="review__body">
						<h5 class="review__heading">Mam Wsparcie u Nauczycieli</h5>
						<p class="review__body-text">
							Dla mnie jednym z najważniejszych aspektów szkoły jest podejście
							nauczycieli. Są dla nas inspiracją, prowadzą nas, motywują do cięższej
							pracy. Okazują nam zrozumienie, szanują nasze zdanie i służą pomocą.
							Zaangażowanie i praca jaką nauczyciele wykonują aby ułatwić nam naukę
							była dla mnie zaskakująca. Lekcje były ciekawe, wiele razy
							rozpoczynaliśmy dyskusje, które kontynuowaliśmy nawet po dzwonku. W
							trudnych momentach w moim życiu prywatnym okazywali mi wsparcie. Było to
							dla mnie bardzo ważne i nawet niekiedy zaskakujące. Wiem, że w innych
							szkołach moi znajomi nie mieli takiej pomocy. I tego będzie mi brakowało
							po zakończeniu szkoły.
						</p>
						<span class="review__attribute">- Zuza</span>
					</div>
				</figure>
			</div>
			<div class="col">
				<figure class="review review--3">
					<div class="review__top"></div>
					<div class="review__body">
						<h5 class="review__heading">Wyjątkowi Ludzie</h5>
						<p class="review__body-text">
							IX Liceum to miejsce spotkania bratnich dusz. To tutaj dzielisz się
							swoją wrażliwością, emocjami i znajdujesz zrozumienie, potem napotykasz
							na osoby, z którymi chcesz podbijać świat i dzielicie coraz więcej
							wspólnych chwil, aż niepostrzeżenie jesteście przyjaciółmi ! To miejsce
							to jedna wielka rodzina, do której nieustannie chcesz wracać.
						</p>
						<span class="review__attribute">- Ania i Hania</span>
					</div>
				</figure>
			</div>
		</div>
	</div>
</section>
<section class="section invisible opacity-0 bg-light" id="section-spirit">
	<div class="text-center u-heading">
		<h1 class="heading-primary">Nie tylko zajęcia artystyczne</h1>
	</div>
	<div class="row">
		<div class="col">
			<p class="spirit__text">
				W naszej szkole wszyscy się znają. Staramy się tworzyć środowisko, w którym
				uczniowie czują się bezpieczni i wiedzą, że mogą liczyć na pomoc kolegów i
				nauczycieli.
			</p>
			<p class="spirit__text my-6">
				Choć nasze liceum kojarzone jest głównie z zajęciami artystycznymi, staramy
				się dbać o wszechstronny rozwój uczniów i przygotować do różnorodnych wyzwań,
				czekających ich w dorosłym życiu. To właśnie dlatego w kolejnych latach nasi
				uczniowie uzyskują z takie wyniki maturalne, które pozwalają im studiować na
				wybranych uczelniach.
			</p>
			<p class="spirit__text my-6">
				Nasi absolwenci studiują na uczelniach artystycznych w Polsce i zagranicą, a
				także na wielu wydziałach takich uczelni jak:
				<b class="important">Uniwersytet Jagielloński w Krakowie, Uniwersytet im. Adama Mickiewicza w
					Poznaniu, Uniwersytet Warszawski, Uniwersytet Wrocławski, Akademii Górniczo
					Hutniczej w Krakowie, Uniwersytet Pedagogiczny w Krakowie, Hanyang
					University w Korei Południowej, University of Central Lancashire,
					Buckinghamshire New University w Londynie, University of Limerick w
					Irlandii</b>
				i innych.
			</p>
			<img src="<?= get_theme_file_uri("assets/img/su-banner.jpg"); ?>" alt="SU Banner" class="spirit__img">
			<p class="spirit__text my-6">
				<b class="important">Jesteśmy uczestnikami Programu #SU-w-ak!</b>
				Projekt „Kącik relaksu” jest finansowany z środków Gminy Miejskiej Kraków w ramach Programu Wsparcia Samorządów Uczniowskich #SU-w-ak („Samorząd Uczniowski w Akcji”), którego operatorem jest Fundacja Oświatowa im. ks. Stanisława Konarskiego w Krakowie.
			</p>
		</div>
	</div>
	<div class="row">
		<div class="col">
			<p class="spirit__text spirit__text--lead">
				Naszą specjalnością jest kształcenie humanistów. Uczymy świadomości
				historycznej, wrażliwości na sztukę, uważności wobec świata współczesnego.
				Chcemy, by nasi uczniowie myśleli samodzielnie, mając na uwadze drugiego
				człowieka. Dbamy o to, by dorastali w atmosferze wzajemnego szacunku, by byli
				otwarci, ale też krytyczni wobec tego, co ich otacza. By wiedza o przeszłości
				pozwalała im formułować sądy na temat teraźniejszości.
			</p>
		</div>
	</div>
</section>
<section class="section invisible opacity-0" id="section-recruitment">
	<div class="recruitment-bg"></div>
	<div class="text-center u-heading">
		<h1 class="heading-primary">Jak możesz do nas dołączyć?</h1>
	</div>
	<div class="recruitment">
		<div class="recruitment__stage">
			<div class="recruitment__box">
				<span class="recruitment__box-number">1</span>
			</div>
			<div class="recruitment__stage-content">
				<h3 class="heading-quartenary">Na początku..</h3>
				<p class="recruitment__text">
					Poproś rodziców lub opiekunów o telefoniczne umówienie terminu rozmowy
					rekrutacyjnej. Nasz numer telefonu to
					<b class="important">12 422 76 89</b> lub
					<b class="important">510 440 286</b>.
				</p>
			</div>
		</div>
		<div class="recruitment__stage">
			<div class="recruitment__box">
				<span class="recruitment__box-number">2</span>
			</div>
			<div class="recruitment__stage-content">
				<h3 class="heading-quartenary">W międzyczasie..</h3>
				<p class="recruitment__text">Pobierz wniosek oraz go wypełnij.</p>
				<p class="recruitment__text">
					<a class="btn-text" href="<?= get_attachment_link(45); ?>"><span class="material-icons" aria-hidden="true">description</span><span>Pobierz wniosek</span></a>
				</p>
			</div>
		</div>
		<div class="recruitment__stage">
			<div class="recruitment__box">
				<span class="recruitment__box-number">3</span>
			</div>
			<div class="recruitment__stage-content">
				<h3 class="heading-quartenary">Następnie..</h3>
				<p class="recruitment__text">
					Przyjedź na rozmowę z co najmniej jednym rodzicem lub opiekunem do szkoły.
					Zabierz ze sobą świadectwo z 7 klasy i wszystko czym chcesz się pochwalić na
					rozmowie. Pamiętaj, <b class="important">to nie jest egzamin</b>.
				</p>
			</div>
		</div>
		<div class="recruitment__stage">
			<div class="recruitment__box">
				<span class="recruitment__box-number">4</span>
			</div>
			<div class="recruitment__stage-content">
				<h3 class="heading-quartenary">I finalnie..</h3>
				<p class="recruitment__text">
					O terminie wyników rekrutacji zostaniesz poinformowany na miejscu.
				</p>
			</div>
		</div>
	</div>
</section>
<section class="section invisible opacity-0" id="section-contact">
	<div class="text-center u-heading">
		<h1 class="heading-primary">Masz dodatkowe pytania?</h1>
		<span class="subheading">Możesz się z nami skontaktować na następujące sposoby:</span>
	</div>
	<div class="contact-bg"></div>
	<div class="contact">
		<div class="row">
			<div class="col">
				<ul class="u-list u-list--vertical">
					<li class="u-list__item">
						<span class="u-list__icon material-icons" aria-hidden="true">phone</span><span class="u-list__text">12 422 76 89 / 510 440 286</span>
					</li>
					<li class="u-list__item">
						<span class="u-list__icon material-icons" aria-hidden="true">mail</span><span class="u-list__text">9liceum.sekretariat@gmail.com</span>
					</li>
					<li class="u-list__item">
						<span class="u-list__icon material-icons" aria-hidden="true">place</span><span class="u-list__text">Brzozowa 6A, 31-050 Kraków</span>
					</li>
					<li class="u-list__item">
						<span class="u-list__icon material-icons" aria-hidden="true">watch_later</span><span class="u-list__text">8:00 - 15:00</span>
					</li>
					<li class="u-list__item">
						<span class="u-list__icon material-icons" aria-hidden="true">account_balance</span>
						<div class="u-list__block">
							<span class="u-list__label">Bank Santander</span><span class="u-list__text">18 1500 1142 1220 6032 6194 0000</span>
						</div>
					</li>
					<li class="u-list__item">
						<span class="u-list__icon bi bi-messenger"></span><span class="u-list__text">Lart studiO - Szkoła Aktorska</span>
					</li>
				</ul>
			</div>
			<div class="col">
				<iframe class="contact__map" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2561.7205089838985!2d19.942459615717052!3d50.0540667794226!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47165b6b20b22171%3A0xec5c1a863ec7b186!2sLart%20studiO%20-%20Policealne%20Studio%20Aktorskie!5e0!3m2!1spl!2spl!4v1642893525789!5m2!1spl!2spl" style="border: 0" allowfullscreen="" loading="lazy"></iframe>
			</div>
		</div>
	</div>
</section>
<section class="section invisible opacity-0" id="section-promo">
	<div class="text-center u-heading">
		<h1 class="heading-primary">Zobacz, co mówi o nas Nela!</h1>
	</div>
	<div class="promo">
		<iframe class="promo__video video" src="https://www.youtube.com/embed/yDrPRzS_NRE" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen="" frameborder="0"></iframe>
	</div>

	<?php get_footer(); ?>