// Intersection Observer - section fades

const hiddenSections = document.querySelectorAll(".section.invisible.opacity-0");

const animation_sectionFade = function (entries) {
	const [entry] = entries;

	if (entry.isIntersecting) {
		entry.target.classList.remove("invisible", "opacity-0");
	}
};

const observer = new IntersectionObserver(animation_sectionFade, {
	root: null,
	threshold: 0.1
});

hiddenSections.forEach((el) => {
	observer.observe(el);
});
