if (window.location.pathname === "/konkurs-recytatorski/") {
	document.addEventListener("DOMContentLoaded", () => {
		const videos = document.querySelectorAll(".competition-video");

		videos.forEach((video) => {
			new Plyr(video, {
				settings: [],
				clickToPlay: true,
				storage: {
					enabled: true,
					key: "plyr"
				},
				controls: ["play-large", "progress", "mute", "volume", "settings", "fullscreen"]
			});

			video.closest(".plyr").classList.add("competition-video-plyr");
		});

		// new Plyr(videoRight, {
		// 	settings: [],
		// 	clickToPlay: true,
		// 	storage: {
		// 		enabled: true,
		// 		key: "plyr"
		// 	},
		// 	controls: ["play-large", "progress", "mute", "volume", "settings", "fullscreen"]
		// });

		anime({
			targets: ".competition-header__heading",
			translateY: ["36px", "0"],
			opacity: [0, 1],
			duration: 1500,
			easing: "easeOutQuad"
		});

		anime({
			targets: ".competition-header__subheading",
			translateY: ["36px", "0"],
			opacity: [0, 1],
			duration: 1500,
			delay: 1600,
			easing: "easeOutQuad"
		});

		anime({
			targets: ".competition__alert",
			translateX: ["36px", "0"],
			opacity: [0, 1],
			duration: 1500,
			delay: 2900,
			easing: "easeOutQuad"
		});

		const competitionSection = document.getElementById("competition-section");
		let hasAnimated = false;

		const competitionObserver = new IntersectionObserver(
			function (entries) {
				if (!entries[0].isIntersecting || hasAnimated) return;

				if (window.innerWidth >= 1024) {
					competitionSection.classList.remove("lg:invisible");

					anime({
						targets: "[data-competition-heading-to-animate]",
						translateY: ["-72px", "0"],
						opacity: [0, 1],
						duration: 2500,
						easing: "easeOutQuad"
					});

					anime({
						targets: "[data-competition-button-cta-to-animate]",
						translateY: ["72px", "0"],
						opacity: [0, 1],
						duration: 2500,
						easing: "easeOutQuad"
					});

					anime({
						targets: "[data-competition-content-to-animate]",
						scale: ["0.75", "1"],
						opacity: [0, 1],
						duration: 1750,
						easing: "easeOutQuad"
					});

					anime({
						targets: "[data-competition-video-left-to-animate]",
						rotate: ["-30deg", "-2deg"],
						translateX: ["-128px", "0"],
						opacity: [0, 1],
						duration: 2500,
						easing: "easeOutQuad"
						// complete: function () {
						// 	this.animatables[0].target.classList.add("animation-wobble");
						// }
					});

					anime({
						targets: "[data-competition-video-right-to-animate]",
						rotate: ["30deg", "2deg"],
						translateX: ["128px", "0"],
						opacity: [0, 1],
						duration: 2500,
						easing: "easeOutQuad"
						// complete: function () {
						// 	this.animatables[0].target.classList.add("animation-wobble");
						// }
					});

					hasAnimated = true;
				}
			},
			{
				root: null,
				threshold: 0.75
			}
		);

		competitionObserver.observe(competitionSection);

		if (window.innerWidth <= 1024) {
			new Splide("#competition-carousel", {
				type: "loop",
				width: "90vw",
				height: "64rem",
				pagination: false
			}).mount();
		}
	});
}
