const SLIDER_GAP = 28;

if (document.querySelector(".classes__badge")) {
	const NAV_HEIGHT = document.querySelector(".classes__badge").scrollHeight * 4 + SLIDER_GAP * 3;

	const classesSlider = new Splide(".splide", {
		perPage: 4,
		perMove: 1,
		autoplay: false,
		pagination: true,
		gap: `${SLIDER_GAP}px`,
		focus: 1,
		updateOnMove: true,
		height: `${NAV_HEIGHT}px`,
		trimSpace: true,
		direction: "ttb",
		classes: {
			next: "splide__arrow--next classes__arrow--up",
			prev: "splide__arrow--prev classes__arrow--down",
			pagination: "splide__pagination classes__pagination"
		},
		breakpoints: {
			1000: {
				direction: "ltr",
				height: "auto",
				perPage: 3,
				trimSpace: true,
				start: 1,
				gap: "20px",
				width: "90vw",
				dragMinThreshold: 40,
				arrows: false,
				pagination: false
			},
			720: {
				perPage: 1,
				start: 0,
				focus: 0
			}
		}
	});

	const classesBadges = document.querySelectorAll(".classes__badge");
	const classesBody = document.querySelector(".classes__body");
	const classesBodyContent = document.querySelector(".classes__body-content");
	const classesPlaceholder = document.querySelector(".classes__placeholder");
	const classesVideo = document.querySelector(".classes__video");
	const classesHeading = document.querySelector(".classes__heading");
	const classesBackground = document.querySelector(".classes-background");

	const initVideoPlayer = function () {
		return new Plyr(classesVideo, {
			settings: ["quality", "speed"],
			clickToPlay: true,
			storage: {
				enabled: true,
				key: "plyr"
			},
			controls: [
				"play",
				"progress",
				"current-time",
				"mute",
				"volume",
				"settings",
				`${window.innerWidth <= 720 ? "fullscreen" : ""}`
			]
		});
	};

	initVideoPlayer();

	classesSlider.on("moved", function (p1, p2, destIndex) {
		classesBadges.forEach((el) => el.classList.remove("classes__badge--active"));

		document
			.querySelector(".splide__slide.is-active")
			.querySelector(".classes__badge")
			.classList.add("classes__badge--active");

		const videoSrc = classesBadges[destIndex].dataset.video;

		classesVideo.innerHTML = `
    <iframe src='${videoSrc}' loading="lazy" srcdoc="<style>* { padding: 0; margin: 0; overflow: hidden; } body, html { height: 100%; } img, svg { position: absolute; width: 100%; top: 0; bottom: 0; margin: auto; } svg { filter: drop-shadow(1px 1px 10px hsla(206.5, 70.7%, 8%)); transition: al .25s ease-in-out; } body:hover svg { filter: drop-shadow(1px 1px 10px hsla(206.5, 70.7%, 8%)); transform: scale(1.2); }</style> <a href='${videoSrc}&autoplay=1'><img src='https://img.youtube.com/vi/20facspdzuE/hqdefault.jpg' alt=''></a>" title="Odtwarzacz YouTube" frameborder="0" allow="clipboard-write; encrypted-media; picture-in-picture; ${
		window.innerWidth <= 720 ? "allowfullscreen" : ""
	}"></iframe>
  `;

		initVideoPlayer();

		classesBackground.style.backgroundImage = `url('/wp-content/uploads/2024/04/${classesBadges[destIndex].dataset.image}.webp')`;

		classesBackground.style.animation = "classesBackground 8s infinite alternate";

		classesHeading.textContent = classesBadges[destIndex].querySelector("span:nth-child(2)").textContent;

		if (document.documentElement.clientWidth >= 1000) {
			classesPlaceholder.classList.remove("hidden");
			classesBodyContent.classList.add("hidden");
		}
	});

	classesSlider.mount();

	document
		.querySelector(".splide__slide.is-active")
		.querySelector(".classes__badge")
		.classList.add("classes__badge--active");

	classesBackground.style.backgroundImage = `url('/wp-content/uploads/2024/04/classes-bg-aktorstwo.webp')`;

	if (document.documentElement.clientWidth >= 1000) {
		classesBody.addEventListener("click", () => {
			classesPlaceholder.classList.add("hidden");
			classesBodyContent.classList.remove("hidden");
		});
	}

	if (document.documentElement.clientWidth <= 1000) {
		classesPlaceholder.classList.add("hidden");
		classesBodyContent.classList.remove("hidden");
	}
}
