<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo("charset"); ?>" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />

	<?php wp_head(); ?>
</head>

<body>
	<div class="nav-btns">
		<button class="nav-btn nav-btn--inactive" id="nav-toggle">
			<div class="nav-btn__content"><span class="nav-btn__bar"></span></div>
		</button>
		<a class="nav-btn" href="<?= esc_url(site_url('/')); ?>">
			<div class="nav-btn__content">
				<span class="nav-btn__icon material-icons" aria-hidden="true">home</span>
			</div>
		</a>
	</div>
	<nav class="nav">
		<div class="nav__backdrop hidden"></div>
		<ul class="nav__list">
			<li class="nav__item">
				<a class="nav__link" href="<?= esc_url(site_url('/konkurs-recytatorski')); ?>">Konkurs recytatorski</a>
			</li>
			<li class="nav__item">
				<a class="nav__link" href="<?= get_attachment_link(69); ?>">Statut szkoły</a>
			</li>
			<li class="nav__item">
				<a class="nav__link" href="<?= esc_url(site_url('/misja')); ?>">Misja szkoły</a>
			</li>
			<li class="nav__item" data-dropdown="1">
				<button class="nav__link" type="button">Rekrutacja</button>
			</li>
			<li class="nav__item">
				<a class="nav__link" href="<?= esc_url(site_url('/faq')); ?>">Częste Pytania</a>
			</li>
			<li class="nav__item" data-dropdown="2">
				<button class="nav__link" type="button">Do pobrania</button>
			</li>
		</ul>
		<ul class="nav__dropdown nav__dropdown--1 hidden">
			<div class="nav__dropdown-wrapper">
				<li class="nav__dropdown-item">
					<a class="nav__dropdown-link" href="<?= esc_url(site_url('/zakwaterowanie')); ?>">Lista burs i internatów</a>
				</li>
				<li class="nav__dropdown-item">
					<a class="nav__dropdown-link" href="<?= esc_url(site_url('/ceny')); ?>">Opłaty</a>
				</li>
			</div>
		</ul>
		<ul class="nav__dropdown nav__dropdown--2 hidden">
			<div class="nav__dropdown-wrapper">
				<li class="nav__dropdown-item">
					<a class="nav__dropdown-link" href="<?= get_attachment_link(45); ?>">Wniosek
						o przyjęcie do szkoły</a>
				</li>
				<li class="nav__dropdown-item">
					<a class="nav__dropdown-link" href="<?= get_attachment_link(47); ?>">Oświadczenie
						woli uczęszczania na lekcje religii</a>
				</li>
				<li class="nav__dropdown-item">
					<a class="nav__dropdown-link" href="<?= get_attachment_link(46); ?>">Oświadczenie woli
						uczęszczania na lekcje religii (dla pełnoletnich)</a>
				</li>
				<li class="nav__dropdown-item">
					<a class="nav__dropdown-link" href="<?= get_attachment_link(48); ?>">Podanie o warunkową
						promocję</a>
				</li>
				<li class="nav__dropdown-item">
					<a class="nav__dropdown-link" href="<?= get_attachment_link(50); ?>">Wniosek o zmianę
						grupy językowej</a>
				</li>
				<li class="nav__dropdown-item">
					<a class="nav__dropdown-link" href="<?= get_attachment_link(51); ?>">Wniosek
						o zwolnienie z lekcji WF</a>
				</li>
				<li class="nav__dropdown-item">
					<a class="nav__dropdown-link" href="<?= get_attachment_link(68); ?>">Standardy ochrony małoletnich </a>
				</li>
			</div>
		</ul>
	</nav>

	<div class="modal u-center-elements hidden">
		<div class="modal__content"></div>
	</div>

	<div class="facebook hidden">
		<a class="facebook__circle" href="https://www.facebook.com/profile.php?id=61558018419818" target="_blank"><img class="facebook__image" src="<?= get_theme_file_uri("assets/img/logo-red.min.png"); ?>" alt="" /></a>
		<div class="facebook__label">
			<span class="facebook__message u-center-elements">Dołącz do naszego Facebooka po więcej świeżych informacji, których tutaj nie
				znajdziesz!</span>
		</div>
		<button class="facebook__close">
			<span class="facebook__close-icon material-icons" aria-hidden="true">close</span>
		</button>
	</div>