<?php

function siteFiles() {
  wp_register_style("main_stylesheet", get_theme_file_uri("/build/index.css"));
  wp_register_style("splide_css", "https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/css/splide.min.css");
  wp_register_style("plyr_css", "https://cdn.plyr.io/3.7.8/plyr.css");

  wp_enqueue_style(["main_stylesheet", "splide_css", "plyr_css"]);

  // Scripts

  wp_register_script("index_js", get_theme_file_uri("/build/index.js"), ["plyr_js"], "1.0", ["strategy" => "defer"]);
  wp_register_script("class_badges_js", get_theme_file_uri("/src/js/class-badges.js"), ["splide_js", "plyr_js"], "1.0", ["strategy" => "defer"]);
  wp_register_script("home_js", get_theme_file_uri("/src/js/home.js"), ["plyr_js"], "1.0", ["strategy" => "defer"]);
  wp_register_script("animations_js", get_theme_file_uri("/src/js/animations.js"), ["anime_js"], "1.0", ["strategy" => "defer"]);
  wp_register_script("main_js", get_theme_file_uri("/src/js/main.js"), ["plyr_js"], "1.0", ["strategy" => "defer"]);
  wp_register_script("competition_js", get_theme_file_uri("/src/js/competition.js"), "1.0", ["strategy" => "defer"]);
  wp_register_script("splide_js", "https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/js/splide.min.js", [], "1.0", []);
  wp_script_add_data("splide_js", "data-cookieconsent", "ignore");
  wp_register_script("plyr_js", "https://cdn.plyr.io/3.7.8/plyr.polyfilled.js", [], "1.0", ["strategy" => "defer"]);
  wp_script_add_data("plyr_js", "data-cookieconsent", "ignore");
  wp_register_script("anime_js", "https://cdnjs.cloudflare.com/ajax/libs/animejs/3.2.2/anime.min.js", [], "1.0", []);
  wp_script_add_data("anime_js", "data-cookieconsent", "ignore");

  wp_enqueue_script(["plyr_js", "index_js", "class_badges_js", "home_js", "competition_js", "animations_js", "main_js", "splide_js", "anime_js"]);
}

function headContent() {
  // Google Fonts / Material Icons
  print "<link href='https://fonts.googleapis.com' rel='preconnect' />";
  print "<link href='https://fonts.gstatic.com' rel='preconnect' />";
  print "<link href='https://fonts.googleapis.com/css2?family=Cormorant+Infant:ital@1&amp;family=Hind:wght@400;500;600;700&amp;family=Prompt:wght@300;400&amp;display=swap' rel='stylesheet' />";
  print "<link href='https://fonts.googleapis.com/icon?family=Material+Icons' rel='stylesheet' />";

  // Bootstrap Icons
  print "<link rel='stylesheet' href='https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css' integrity='sha384-4LISF5TTJX/fLmGSxO53rV4miRxdg84mZsxmO8Rx5jGtp/LbrixFETvWa5a6sESd' crossorigin='anonymous'>";
}

function siteFeatures() {
  add_theme_support('title-tag');
}

add_action("after_setup_theme", "siteFeatures");
add_action("wp_head", "headContent");
add_action("wp_enqueue_scripts", "siteFiles");
